package automobile;

import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;

/**
 * Second garage, affichant les véhicules qu'il contient
 * Utilise des TreeSet
 * Container de Véhicules
 * Implémente un itérateur Iterable
 * On pourrait tenter d'étendre Garage1 pour éviter les répétitions, mais je n'ai pas réussi à appeler le
 * bon constructeur dans IteratorGarage de cette façon (il appelait toujours celui prenant un ArrayList en
 * paramètre, comme si on ne pouvait pas écraser l'attribut list dans une classe fille)
 * @author Adrien Poupa
 */
public class Garage2 implements Iterable<Vehicule> {

    TreeSet<Vehicule> list;

    /**
     * Constructeur par défaut de Garage1
     * Instancie le TreeSet avec pour méthode de classement l'ordre des immatriculations
     */
    public Garage2() {
        list = new TreeSet<>(new GarageTriImmatriculion());
    }

    /**
     * Constructeur prenant un comparateur en paramètre
     * @param comparateur constructeur à prendre en compte lors de la construction de la liste
     */
    public Garage2 (Comparator<Vehicule> comparateur) {
        list = new TreeSet<>(comparateur);
    }

    /**
     * Ajout d'un véhicule au garage
     * Rien de particulier ici, on utilise la méthode native de TreeSet
     * @param voiture objet Vehicule à ajouter
     */
    public void add(Vehicule voiture) {
        list.add(voiture);
    }

    /**
     * Itérateur de Garage1, contenant des Véhicules
     * Retourne une nouvelle instance de l'itérateur de garage2 prenant en paramètre le TreeSet de voiture
     * @return objet iterator contenant les Céhicules
     */
    public Iterator<Vehicule> iterator() {
        return new IteratorGarage(list);
    }

    /**
     * Surcharge de toString, affiche les Véhicules contenus dans le garage
     * @return liste du type "Vehicule X : compteur = [Totalisateur = X | Partiel = X]; jauge = X"
     */
    @Override
    public String toString() {
        StringBuilder returnString = new StringBuilder();

        for(Vehicule vehicule : list) {
            returnString.append(vehicule.toString());
            returnString.append(System.getProperty("line.separator")); // Retour à la ligne
        }

        return returnString.toString();
    }

    /**
     * Tri des voitures par numéro d'immatriculation
     * J'ai laissé Immatriculion tel qu'implémenté dans la classe de tests...
     * Ici, on crée une nouvelle liste TreeSet dans laquelle on spéficie un nouvel ordre de tri
     * défini dans la classe GarageTriImmatriculion (même typo), on ajoute ensuite tous nos éléments
     * actuels dans cette nouvelle liste, qui sera bien triée selon l'ordre spécifié
     * On remplace ensuite la liste actuelle par cette nouvelle liste, triée selon l'ordre voulu
     */
    public void triNoImmatriculion() {
        TreeSet<Vehicule> newList = new TreeSet<>(new GarageTriImmatriculion());
        for(Vehicule vehicule : list) {
            newList.add(vehicule);
        }
        list = newList;
    }

    /**
     * Tri des voitures par compteur
     * Ici, on crée une nouvelle liste TreeSet dans laquelle on spéficie un nouvel ordre de tri
     * défini dans la classe CompteurComparator, on ajoute ensuite tous nos éléments
     * actuels dans cette nouvelle liste, qui sera bien triée selon l'ordre spécifié
     * On remplace ensuite la liste actuelle par cette nouvelle liste, triée selon l'ordre voulu
     */
    public void triCompteur() {
        TreeSet<Vehicule> newList = new TreeSet<>(new CompteurComparator());
        for(Vehicule vehicule : list) {
            newList.add(vehicule);
        }
        list = newList;
    }
}
